/*:
 * @plugindesc YEP_EquipCoreをもっとタッチタッチさせる装置
 * 
 * @author LefTonbo
 *
 */

(function(){

//=============================================================================
// Scene_Skill
//=============================================================================

var _Scene_Skill_update = Scene_Skill.prototype.update;
Scene_Skill.prototype.update = function() {
    _Scene_Skill_update.call(this);
    if (this.isActive()) this.updateRightWindowTriggers();
};

Scene_Skill.prototype.updateRightWindowTriggers = function() {
    if (this.isRightWindowTouched()) {
        SoundManager.playCursor();
        this.nextActor();
    }
};

Scene_Skill.prototype.isRightWindowTouched = function() {
    if (!TouchInput.isTriggered()) return false;
    var x = TouchInput.x;
    var y = TouchInput.y;
    var rect = new Rectangle();
    rect.x = this._statusWindow.x;
    rect.y = this._statusWindow.y;
    rect.width = this._statusWindow.x + this._statusWindow.width;
    rect.height = this._statusWindow.y + this._statusWindow.height;
    return (x >= rect.x && y >= rect.y && x < rect.width && y < rect.height);
};

_Scene_Skill_onActorChange = Scene_Skill.prototype.onActorChange;
Scene_Skill.prototype.onActorChange = function() {
    var isSkillMode = false;
    var isSkillLearnMode = false;
    var typeIndex = this._skillTypeWindow.index();
    var subIndex = -1;
    if (this._itemWindow.index() >= 0) {
      isSkillMode = true;
      subIndex = this._itemWindow.index();
    }
    if (this._skillLearnWindow && this._skillLearnWindow.index() >= 0) {
      isSkillLearnMode = true;
      subIndex = this._skillLearnWindow.index();
    }
    _Scene_Skill_onActorChange.call(this);
    this._skillTypeWindow.select(typeIndex);
    if (isSkillMode) {
      this._skillTypeWindow.deactivate();
      this._itemWindow.select(subIndex);
    }
    if (isSkillLearnMode) {
      this._skillTypeWindow.deactivate();
      this._skillLearnWindow.select(subIndex);
    }
};

//=============================================================================
// Scene_Equip
//=============================================================================

var _Scene_Equip_update = Scene_Equip.prototype.update;
Scene_Equip.prototype.update = function() {
    _Scene_Equip_update.call(this);
    if (this.isActive()) this.updateRightWindowTriggers();
};

Scene_Equip.prototype.updateRightWindowTriggers = function() {
    if (!this._itemWindow.active && this.isRightWindowTouched()) {
        SoundManager.playCursor();
        this.nextActor();
    }
};

Scene_Equip.prototype.isRightWindowTouched = function() {
    if (!TouchInput.isTriggered()) return false;
    var x = TouchInput.x;
    var y = TouchInput.y;
    var rect = new Rectangle();
    rect.x = this._statusWindow.x;
    rect.y = this._statusWindow.y;
    rect.width = this._statusWindow.x + this._statusWindow.width;
    rect.height = this._statusWindow.y + this._statusWindow.height;
    return (x >= rect.x && y >= rect.y && x < rect.width && y < rect.height);
};

//=============================================================================
// Scene_Status
//=============================================================================

var _Scene_Status_update = Scene_Status.prototype.update;
Scene_Status.prototype.update = function() {
    _Scene_Status_update.call(this);
    if (this.isActive()) this.updateRightWindowTriggers();
};

Scene_Status.prototype.updateRightWindowTriggers = function() {
    if (this.isRightWindowTouched()) {
        SoundManager.playCursor();
        this.nextActor();
    }
};

Scene_Status.prototype.isRightWindowTouched = function() {
    if (!TouchInput.isTriggered()) return false;
    var x = TouchInput.x;
    var y = TouchInput.y;
    var rect = new Rectangle();
    rect.x = this._statusWindow.x;
    rect.y = this._statusWindow.y;
    rect.width = this._statusWindow.x + this._statusWindow.width;
    rect.height = this._statusWindow.y + this._statusWindow.height;
    return (x >= rect.x && y >= rect.y && x < rect.width && y < rect.height);
};

//=============================================================================

}());

// EOF